/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockLucisMushroom;
import org.betterx.betternether.blocks.BlockLucisSpore;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class LucisFeature
extends ContextFeature<NoneFeatureConfiguration>
implements UserGrowableFeature<NoneFeatureConfiguration> {
    private static final BlockState CENTER = (BlockState)NetherBlocks.LUCIS_MUSHROOM.m_49966_().m_61124_(BlockLucisMushroom.SHAPE, (Comparable)((Object)BNBlockProperties.EnumLucisShape.CENTER));
    private static final BlockState SIDE = (BlockState)NetherBlocks.LUCIS_MUSHROOM.m_49966_().m_61124_(BlockLucisMushroom.SHAPE, (Comparable)((Object)BNBlockProperties.EnumLucisShape.SIDE));
    private static final BlockState CORNER = (BlockState)NetherBlocks.LUCIS_MUSHROOM.m_49966_().m_61124_(BlockLucisMushroom.SHAPE, (Comparable)((Object)BNBlockProperties.EnumLucisShape.CORNER));

    public LucisFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        return this.grow(world, pos, random, false);
    }

    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, boolean force) {
        if (force || this.canGenerate(world, pos)) {
            if (random.m_188503_(3) == 0) {
                if (this.canReplace(world.m_8055_(pos))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos, CENTER);
                }
                if (this.canReplace(world.m_8055_(pos.m_122012_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122012_(), (BlockState)SIDE.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.NORTH));
                }
                if (this.canReplace(world.m_8055_(pos.m_122019_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122019_(), (BlockState)SIDE.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.SOUTH));
                }
                if (this.canReplace(world.m_8055_(pos.m_122029_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122029_(), (BlockState)SIDE.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.EAST));
                }
                if (this.canReplace(world.m_8055_(pos.m_122024_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122024_(), (BlockState)SIDE.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.WEST));
                }
                if (this.canReplace(world.m_8055_(pos.m_122012_().m_122029_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122012_().m_122029_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.SOUTH));
                }
                if (this.canReplace(world.m_8055_(pos.m_122012_().m_122024_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122012_().m_122024_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.EAST));
                }
                if (this.canReplace(world.m_8055_(pos.m_122019_().m_122029_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122019_().m_122029_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.WEST));
                }
                if (this.canReplace(world.m_8055_(pos.m_122019_().m_122024_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122019_().m_122024_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.NORTH));
                }
            } else {
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_() == NetherBlocks.LUCIS_SPORE) {
                    if (state.m_61143_((Property)BlockLucisSpore.FACING) == Direction.SOUTH) {
                        pos = pos.m_122012_();
                    } else if (state.m_61143_((Property)BlockLucisSpore.FACING) == Direction.WEST) {
                        pos = pos.m_122029_();
                    }
                } else if (!world.m_8055_(pos.m_122012_()).m_60795_()) {
                    pos = pos.m_122012_();
                } else if (!world.m_8055_(pos.m_122029_()).m_60795_()) {
                    pos = pos.m_122029_();
                }
                if (this.canReplace(world.m_8055_(pos))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.SOUTH));
                }
                if (this.canReplace(world.m_8055_(pos.m_122024_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122024_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.EAST));
                }
                if (this.canReplace(world.m_8055_(pos.m_122019_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122019_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.WEST));
                }
                if (this.canReplace(world.m_8055_(pos.m_122019_().m_122024_()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_122019_().m_122024_(), (BlockState)CORNER.m_61124_((Property)BlockLucisMushroom.FACING, (Comparable)Direction.NORTH));
                }
            }
            return true;
        }
        return false;
    }

    private boolean canReplace(BlockState state) {
        return state.m_60734_() == NetherBlocks.LUCIS_SPORE || state.m_247087_();
    }

    private boolean canGenerate(ServerLevelAccessor world, BlockPos pos) {
        for (Direction dir : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            BlockState state = world.m_8055_(pos.m_121945_(dir));
            if (!BlocksHelper.isNetherrack(state) && !NetherBlocks.MAT_ANCHOR_TREE.isTreeLog(state.m_60734_())) continue;
            return true;
        }
        return false;
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random, true);
    }
}

